-- File name   : RA2_TOOLSET.MS
-- Title       : RED ALERT2 tools
-- Category    : not implemented yet
-- Environment : 3ds max 3&4, GMAX
-- Description : toolset for RA2 SHP building
-- Reference   :
-- Copyright (c) 2002 by Flyby
-- VERSION		: 1.10


-- Let the games begin..... -----------------------------------------------





rollout SETUPTOOLS "RA2   SETUP TOOLS" 
(
--local camd
--grptxt01="3DSMAX render" as string

group "Reference Foundation"
	(
	label labtxt01 "RIGHT" align:#left
	radiobuttons reffnd_R labels:#("1","2","3","4","5","6")  align:#centre height:20 columns:6
	label labtxt02 "LEFT" align:#left
	radiobuttons reffnd_L labels:#("1","2","3","4","5","6")  align:#centre height:20 columns:6
--	label labtxt03 "HEIGHT" align:#left
--	radiobuttons reffnd_H labels:#("1","2","3","4","5","6")  align:#centre height:20 columns:6
	button do_reffnd " Create Reference Object " width:150 height:25 align:#centre
	button do_shdwmatte " Create Ground Plane" width:150 height:25 align:#centre
	)



group "Camera Tools"
	(
	radiobuttons S_W_N_E labels:#("South-West","North-West","North-East","South-East") columns:2 align:#centre height:30
	button do_cam " Create Camera " width:150 height:25 align:#centre
	slider camdist "Camera Distance" range:[0,329,0] ticks:2
	)
group "Light Tools"
	(
	button do_shadow_lite " Create shadow light " width:150 height:25 align:#centre
	button do_cam_lite " Create Fill lights " width:150 height:25 align:#centre

	)



--group "GMAX - Prepare Screencap"
--	(
--	checkbox backgr "Set background" checked:true
--	checkbox remgrid "Remove grid" checked:true
--	button do_prepare " Prepare " width:80 height:25 align:#centre
--	)
---------------------------------------------------------------------------
on do_shadow_lite pressed do
(
		litepos = case S_W_N_E.state of
			(
				1:[-500,220,725] ----[-100,-100,84] [-500,220,725] 
				2:[220,500,725]--[-100,100,84]
				3:[500,-220,725]---[100,100,84]
				4:[-220,-500,725]--[100,-100,84]
			)


targetSpot name:"ShadowCaster" raytracedShadows:true castShadows:on target:(Targetobject transform:(matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0])) pos:litepos rgb:(color 255 255 255) shadowColor:(color 0 0 0) multiplier:.8 contrast:50 softenDiffuseEdge:50 nearAttenStart:0 nearAttenEnd:40 farAttenStart:80 farAttenEnd:200 decayRadius:40 atmosOpacity:100 atmosColorAmt:100 shadowMultiplier:1 hotspot:20 falloff:30 aspect:1 --isSelected:on 
)

on do_cam_lite pressed do
(
		litepos1 = case S_W_N_E.state of
			(
				1:[-250,-250,250]
				2:[-250,250,250]
				3:[250,250,250]
				4:[250,-250,250]
			)
		litepos2 = case S_W_N_E.state of
			(
				1:[-250,-250,50]
				2:[-250,250,50]
				3:[250,250,50]
				4:[250,-250,50]
			)
		litepos3 = case S_W_N_E.state of
			(
				1:[0,-350,100]
				2:[-350,0,100]
				3:[0,350,100]
				4:[350,0,100]
			)


targetSpot name:"Cameralight" castShadows:on target:(Targetobject transform:(matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0])) pos:litepos1 rgb:(color 255 255 255) shadowColor:(color 0 0 0) multiplier:.4 contrast:25 softenDiffuseEdge:50 nearAttenStart:0 nearAttenEnd:40 farAttenStart:80 farAttenEnd:200 decayRadius:40 atmosOpacity:100 atmosColorAmt:100 shadowMultiplier:.25 hotspot:20 falloff:30 aspect:1 excludeList:#($Shadowplane)--isSelected:on 
targetSpot name:"Filllight01" castShadows:on target:(Targetobject transform:(matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0])) pos:litepos2 rgb:(color 255 255 255) shadowColor:(color 0 0 0) multiplier:.4 contrast:25 softenDiffuseEdge:50 nearAttenStart:0 nearAttenEnd:40 farAttenStart:80 farAttenEnd:200 decayRadius:40 atmosOpacity:100 atmosColorAmt:100 shadowMultiplier:1 hotspot:20 falloff:30 aspect:1 excludeList:#($Shadowplane)--isSelected:on 
targetSpot name:"Filllight02" castShadows:on target:(Targetobject transform:(matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0])) pos:litepos3 rgb:(color 255 255 255) shadowColor:(color 0 0 0) multiplier:.5 contrast:25 softenDiffuseEdge:50 nearAttenStart:0 nearAttenEnd:40 farAttenStart:80 farAttenEnd:200 decayRadius:40 atmosOpacity:100 atmosColorAmt:100 shadowMultiplier:1 hotspot:40 falloff:50 aspect:1 excludeList:#($Shadowplane)--isSelected:on 

)


on do_reffnd pressed do
( 
local mp_r,mp_l,mp_h
local sr,sl,sh,sl2,sr2
try (delete $Ref_Foundation) catch()

mp_r=1
mp_l=1
mp_h=1


--print reffnd_R.state
mp_r = case reffnd_R.state of
			(
				1:(1)
				2:(2)
				3:(3)
				4:(4)
				5:(5)
				6:(6)
			)
mp_l = case reffnd_L.state of
			(
				1:(1)
				2:(2)
				3:(3)
				4:(4)
				5:(5)
				6:(6)
			)
--mp_h = case reffnd_H.state of
--			(
--				1:(1)
--				2:(2)
--				3:(3)
--				4:(4)
--				5:(5)
--				6:(6)
--			)
mp_h = 2
sr=19.5*mp_r
sl=19.5*mp_l
sh=19.5*mp_h
sl2=(sl/2)
sr2=(sr/2)

trn = case S_W_N_E.state of
			(
				1:[-sl2,-sr2,0]
				2:[-sl2,sr2,0]
				3:[sl2,sr2,0]
				4:[sl2,-sr2,0]
			)

-- dummy name:"Ref_Foundation"  boxsize:[sl,sr,sh] pos:[-sl/2,-sr/2,sh/2]  backFaceCull:false  --pivot:[19.5/2,19.5/2,19.5/2]
box name:"Ref_Foundation" height:sh length:sr width:sl pos:trn xray:true
viewport.activeViewport = 4
max wire smooth
)


on do_shdwmatte pressed do
(
try (delete $ShadowPlane) catch ()
plane length:500 width:500 name:"ShadowPlane" gbufferChannel:13
$ShadowPlane.material= matteShadow() 
$ShadowPlane.material.color = color  85 255 85
$ShadowPlane.material.receiveShadows = true


)



-- on inputfrme








 on do_prepare pressed do
 	(
		print "preparing GMAX"
		--max background
		--setBackGround [0,0,255]
	)

 on do_cam pressed do
	(
		try
		(	
			delete $lights
			delete $camera01
		)
		catch()

		viewport.ResetAllViews ()
		camd= case S_W_N_E.state of
			(
				1:[-100,-100,84]
				2:[-100,100,84]
				3:[100,100,84]
				4:[100,-100,84]
			)

		cam=Targetcamera  pos:camd isSelected:on target:(Targetobject transform:(matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0]))
		cam.fov = 65.47
		cam.orthoProjection=true
		viewport.activeViewport = 4
		viewport.setCamera cam

--		if 
--		(
--		(maxversion())[2]==128
--		)
--		then 
--		(do_render.enabled=false
--		--maxgrp.enabled=false
--		labtxt01.text = "Renderer not available in GMAX"
--		)
--		else
--		(backgr.enabled=false
--		remgrid.enabled=false
--		do_prepare.enabled=false
--		)



	)

 on camdist changed val do
	(
		try
		(


			camd= case S_W_N_E.state of
			(
				1:[-100-camdist.value,-100-camdist.value,tan(30)*sqrt(2*(camdist.value*camdist.value))+84]
				2:[-100-camdist.value,100+camdist.value,tan(30)*sqrt(2*(camdist.value*camdist.value))+84]
				3:[100+camdist.value,100+camdist.value,tan(30)*sqrt(2*(camdist.value*camdist.value))+84]
				4:[100+camdist.value,-100-camdist.value,tan(30)*sqrt(2*(camdist.value*camdist.value))+84]
			)
			$Camera01.pos = camd
		)
		catch (messageBox "Life would be much better if you first make a CAMERA, don't you agree ...?")
	)
)--close rollout


rollout GMAXSHPTOOLS "GMAX   SHP TOOLS" 
(
)




rollout MAXSHPTOOLS "RA2   RENDER TOOLS" 
(
group "3DSMAX Setup" 
	(
		button do_renderfx " Add Contrast FX" width:150 height:25 align:#centre
		button importlegalcolors " Import RA2 palette " width:150 height:25 enabled:false
		--progressbar import_progress color:red width:200 height:10 enabled:false


	)

group "3DSMAX Render" 
	(
	
		label labtxt06 "Output size" align:#left --enabled:false
		radiobuttons selctsize labels:#("544x308","000x000","000x000","000x000","000x000","000x000") columns:3 align:#centre height:30
		
		--label labtxt04 "" align:#left 
		spinner inputfrme "# frames to render                   " range:[0,100,1] fieldwidth:30 align:#left type:#integer
		label labtxt04 "AA filter" align:#left 
		radiobuttons AAfilter labels:#("Hard","Normal      ","Soft") columns:3 align:#left height:15

		button do_render " RENDER  " width:150 height:40 align:#centre
		label labtxt05 "Shadow Extraction Progress" align:#left --enabled:false
		progressbar shadow_progress color:red width:200 height:10 --enabled:false

		--label labtxt05 "palette converting progress" align:#left enabled:false
		--progressbar palette_progress color:red width:200 height:10 enabled:false

	)
----------------------------------------------
on do_renderfx pressed do
	(
	global efx01
	efx01 = brightness_and_contrast Brightness:.35 Contrast:.70 ignore_background:true --ingnoreBack:true
	efx01.name= "RA2 WestWood Look"
	addEffect efx01
	)
----------------------------------------------
on  importlegalcolors pressed do
	(
	palfile = getopenFileName filename:"c:\\Westwood\\RA2\\unittem.pal" types:"JASC palette for RA2 units (*.PAL)|*.PAL"
	palette = openFile palfile	
	import_progress.value = 0
	arraycounter=0
		for i=1 to 3 do
			(
				skipToNextLine palette
			)
	legalarray	= #()
		for i=4 to 256 do
			(
				legalcol = stringstream (readLine palette)
				r = (readDelimitedString legalcol " ") as integer
				g = (readDelimitedString legalcol " ") as integer
				b = (readDelimitedString legalcol " ") as integer
				legallist = color r g b i 
				append legalarray legallist
				import_progress.value = 100.*(i-3)/(256-3)
				arraycounter=arraycounter+1
			)
	close

	)
------------------------------------------------
 on do_render pressed do
 	(
	global mymap
	global nomymap
	global efx01
	backgroundColor = color 0 0 255
		animsize = case selctsize.state of
			(
				1:[544,308]
				2:[0,0]
				3:[0,0]
				4:[0,0]
				5:[0,0]
				6:[0,0]
			)
		R_filter = case AAfilter.state of
			(
				1:(Catmull_Rom ())
				2:(Area ())
				3:(Soften ())

			)

	nomymap = bitmap animsize.x animsize.y 
	mymap = bitmap animsize.x animsize.y 
	fin = inputfrme.value
	print fin
--	paloption == 1
--if paloption == 0
--then
--(
for frme =0 to fin-1 do
	(
	$Shadowplane.ishidden=true
	render camera:$camera01 outputsize:[animsize.x,animsize.y] to:mymap vfb:on frame:frme antiAliasing:true antiAliasFilter:R_filter--fromframe:0 toframe:38
	$Shadowplane.ishidden=false
	setActive efx01 false
	render camera:$camera01 outputsize:[animsize.x,animsize.y] to:nomymap vfb:on frame:frme antiAliasing:false channels:#(#objectID) --antiAliasFilter:R_filter fromframe:0 toframe:38
	shadow_progress.value=0
	for r=0 to animsize.y-1 do
		(
			
			shadow_pixels=getpixels nomymap [0,r] animsize.x
			for c=1 to animsize.x do 					
					(
						shadow_bmp=shadow_pixels[c]
						if shadow_bmp == (color 85 255 85)
						then
						(setpixels nomymap [c,r] #(color 0 0 198))
						else
						(setpixels nomymap [c,r] #(color 0 0 255))
						--format "%\n" shadow_bmp
					)
			shadow_progress.value = 100.*(r)/(animsize.y-1)
		)
	shadow_progress.value=0
	 	display nomymap
		setActive efx01 false
		--test = scanlineRender.antiAliasFilter
		--format "%\n" test
--------------------------------paletteconversion------------------------
--	palette_progress.value = 0
--	top=mymap
--	ht=top.height
--	wt=top.width
--	delta = 255*255+255*255+255*255
--	palcomp= createfile "C:\\Program Files\\3dsmax3_1\\Scripts\\paltest2.txt"
--	palbitmap = #()
--	for r=0 to ht-1 do
--		( 
--			pixels=getpixels top [0,r] wt 		
--				for c=1 to wt do 					
--					(
--						bmp=pixels[c]
--						
--					--format "%\n" bmp	
--					if bmp != color 0 0 255 
--					then 
--					(
--						
--						for a=1 to arraycounter do 
--						( 	
--							pal=legalarray[a]
--							--format "%\n" 
--							palr =pal.r as integer
--							palg =pal.g as integer
--							palb =pal.b as integer
--							bmpr =bmp.r as integer
--							bmpg =bmp.g as integer
--							bmpb =bmp.b as integer
--							dist_r =abs(palr - bmpr)
--							dist_g =abs(palg - bmpg)
--							dist_b =abs(palb - bmpb)
--							--dist = dist_r + dist_g + dist_b
--							dist = ((dist_r*dist_r) + (dist_g*dist_g) + (dist_b*dist_b))
--							--dist = sqrt((dist_r*dist_r) + (dist_g*dist_g) + (dist_b*dist_b))
--						if 
--							dist < delta
--						do
--							indexpal = (pal.a as integer-4) --need to substractbecause array index starts at 4
--
--						if 
--							dist < delta
--						do
--							rpal = (pal.r as integer)
--
--						if 
--							dist < delta
--						do
--							gpal = (pal.g as integer)
--
--						if 
--							dist < delta
--						do
--							bpal = (pal.b as integer)
--
--						if 
--							dist < delta
--						do
--							delta=dist 
--							--format "%\t%\t%\t%\n" dist_r dist_g dist_b dist
--						)
--					)
--
						--format "%\t%\n" indexpal delta to:palcomp
						--format "%\t%\t%\t%\n" indexpal rpal gpal bpal to:palcomp
--						convertcolor = color rpal gpal bpal 
--						append palbitmap convertcolor
--						
--						delta = 255*255+255*255+255*255
--					)
--			palette_progress.value = 100.*(r)/(ht-1)
--		)
------------------------------- end conversion ----------------------------
print "preparing MAX"
	)
--)
--else 
--	(
--		for frme =0 to fin do
--		(
--		importlegalcolors.enabled = false
--		render camera:$camera01 outputsize:[animsize.x,animsize.y] to:mymap vfb:on frame:frme 
--		)
--	)
)

)--end rneder rollout





rollout INFTOOLS "RA2    INFANTRY TOOLS" 
(
	group "Infantry Tools"
	(
	)


)





rollout WHO_ "About" 
(
	label l1 "RA2 SHP TOOLS"
	label l2 "Version 1.10"
	label l3 "by Flyby"
)










-- create the rollout window and add the  rollout
if FloaterExampleFloater != undefined do
				(
				closerolloutfloater FloaterExampleFloater
				)		
FloaterExampleFloater = newRolloutFloater "RED ALERT2 TOOLSET" 250 850 
addRollout SETUPTOOLS FloaterExampleFloater
--addRollout GMAXSHPTOOLS FloaterExampleFloater --rolledUp:true
addRollout MAXSHPTOOLS FloaterExampleFloater --rolledUp:true
addRollout INFTOOLS FloaterExampleFloater rolledUp:true
addRollout WHO_ FloaterExampleFloater rolledUp:true


